#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <signal.h>

#include "display.h"
#define port 13002
#define BufSize 128

static void *gfBuf;
static unsigned long gfBufSize=0;
unsigned long GetFragments(unsigned short int *buf, unsigned long bytes)
{
    unsigned long res=0;
    unsigned long utmp;
    unsigned short int *bufptr=buf;
    
    if (gfBufSize)
    {
	utmp=(((unsigned short int*)gfBuf)[0]+10)*2-gfBufSize;
	if (utmp>bytes)
	{
	    memcpy(gfBuf+gfBufSize,bufptr,bytes);
	    gfBufSize+=bytes;
	    return 0;
	}

	memcpy(gfBuf+gfBufSize,bufptr,utmp);
	bytes-=utmp;
	res++;
	Display(gfBuf);
	free(gfBuf);
	gfBufSize=0;
    }
    
    while (bytes>2)
    {    
	bufptr++;bytes-=2;
	utmp=((unsigned short int*)bufptr)[0]+10;
	if (utmp*2<=bytes) 
	{
	    res++;
	    Display(bufptr);
	    bytes-=2*utmp;
	    bufptr+=utmp;
	}
	else
	{
	    gfBufSize=bytes;
	    gfBuf=(void*)malloc(utmp*2);
	    ((unsigned short int*)gfBuf)[0]=0; /* If only 1 byte passed we will
			have in gfBuf[0] low byte of nch, but nch is byte sized
			so all be OK */
	    memcpy(gfBuf,bufptr,gfBufSize);
	    bytes=0;
	}
    }
    return res;
}

static int dsock,csock=-1;
static struct sockaddr_in clientaddr;
static int clientaddrsize=sizeof(struct sockaddr_in);

void BrokenPipe()
{
    close(csock);csock=-1;
//  GoodClient=0;
    puts("Disconnecting");
    while (csock<0)
    {
	csock=accept(dsock,(struct sockaddr*)&clientaddr,&clientaddrsize);
	if (!csock) fprintf(stderr,"Can't open connection!\n");
	else puts("Accepting");
    }
}

main()
{
    extern int errno;
    int err;
    unsigned long utmp;
    unsigned char GoodClient=0;
    unsigned short int buf[BufSize];
    struct sockaddr_in servaddr;

    signal(SIGPIPE,BrokenPipe);

    dsock=socket(PF_INET,SOCK_STREAM,IPPROTO_TCP);
    if (dsock<0)
    {
	fprintf(stderr,"Can't open socket!");
	exit(1);
    }
    
	// Configuring server port ( Parsing configuration )
    servaddr.sin_family=AF_INET;
    servaddr.sin_port=htons(port);
    servaddr.sin_addr.s_addr=htonl(INADDR_ANY);
    
    if (bind(dsock,(struct sockaddr*)&servaddr,sizeof(struct sockaddr_in)))
    {
	fprintf(stderr, "Can't bind socket on port %lu\n",port);
	exit(1);
    }

    if (listen(dsock,1))
    {
	fprintf(stderr,"Listen return's with error!\n");
	exit(1);
    }
    
    while (csock<0)
    {
	csock=accept(dsock,(struct sockaddr*)&clientaddr,&clientaddrsize);
	if (!csock) fprintf(stderr,"Can't open connection!\n");
	else puts("Accepting");
    }
    
    while (1)
    {
	err=recv(csock,(void*)buf,BufSize*2,0);
	if (err>0)
	{
	    if (buf[0]==0xD2) GoodClient=1;
	    if (GoodClient) 
	    {
		utmp=GetFragments(buf,err);
		err=send(csock,&utmp,sizeof(unsigned long),0);
		if (err!=sizeof(unsigned long)) BrokenPipe();
	    }
	}
	else if (err==0) BrokenPipe();/* Socket closed on other side */
    }
}
