unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ADODB, Db, StdCtrls, Spin, Grids, DBGrids, dbcgrids, DBCtrls;
//       :
// ADOConnection
//     AdoConnection1.ConnectionString:=Provider=SQLOLEDB.1;Integrated Security=SSPI;Persist Security Info=False;Initial Catalog=master;Data Source=.\WINCC
//     wisard' (...)
//(     AdoConnection1.Provider,   
//     ConnectionString)
// ADOCommand
//      ADOCommand1.Connection   / 
//      ADOCommand1.CommandText := SELECT RTRIM( name),dbid FROM sysdatabases WHERE name LIKE 'CC%'
//      ADOCommand1.CommandType:=CmdText; //   
//  -      ...      SQL 
type
  TForm1 = class(TForm)
    ADOConnection1: TADOConnection;
    ADOCommand1: TADOCommand;
    ADODataSet1: TADODataSet;
    GroupBox1: TGroupBox;
    Button2: TButton;
    ComboBox1: TComboBox;
    Label2: TLabel;
    Button1: TButton;
    Label1: TLabel;
    ComboBox2: TComboBox;
    Edit1: TEdit;
    Edit2: TEdit;
    Button3: TButton;
    SS: TLabel;
    Label3: TLabel;
    Button4: TButton;
    procedure Button4Click(Sender: TObject);
    procedure EngineSelect(Sender: TObject);
    procedure EngineLoad(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Activate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure UpdateClasses;
    procedure UpdateDatabases;
    procedure UpdateServers;
    procedure GetClassDatabases(clname: String; names: TStrings);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses Unit2, ADOInt, Variants, ActiveX, ComObj, OleDB, RegExpr;

{$R *.DFM}

procedure TForm1.UpdateServers();
var
  RSCon: ADORecordsetConstruction;
  Rowset: IRowset;
  SourcesRowset: ISourcesRowset;
  SourcesRecordset: _Recordset;
  SourcesName, SourcesType: TField;

    function PtCreateADOObject
             (const ClassID: TGUID): IUnknown;
    var
      Status: HResult;
      FPUControlWord: Word;
    begin
      asm
        FNSTCW FPUControlWord
      end;
      Status := CoCreateInstance(
                  CLASS_Recordset,
                  nil,
                  CLSCTX_INPROC_SERVER or
                  CLSCTX_LOCAL_SERVER,
                  IUnknown,
                  Result);
      asm
        FNCLEX
        FLDCW FPUControlWord
      end;
      OleCheck(Status);
    end;
begin
  SourcesRecordset := 
      PtCreateADOObject(CLASS_Recordset) 
      as _Recordset;
  RSCon :=
      SourcesRecordset 
      as ADORecordsetConstruction;
  SourcesRowset :=
      CreateComObject(ProgIDToClassID('SQLOLEDB Enumerator'))
      as ISourcesRowset;
  OleCheck(SourcesRowset.GetSourcesRowset(
       nil, 
       IRowset, 0,
       nil,
       IUnknown(Rowset)));
  RSCon.Rowset := RowSet;
  with TADODataSet.Create(nil) do
  try
    Recordset := SourcesRecordset;
    SourcesName := FieldByName('SOURCES_NAME');
    SourcesType := FieldByName('SOURCES_TYPE');
    try
      Form1.Combobox2.Clear();
      while not EOF do
      begin
        if
           (SourcesType.AsInteger = DBSOURCETYPE_DATASOURCE)
           and (SourcesName.AsString <> '') then
          Form1.Combobox2.Items.Add(SourcesName.AsString);
        Next;
      end;
    finally
    end;
  finally
    Free;
  end;
end;


procedure TForm1.UpdateDatabases();
var
  i: Byte;
begin
  try
    Form1.ADOConnection1.Close;
    Form1.ADOConnection1.ConnectionString := Form1.Edit1.Text;

    Form1.ADODataSet1.Recordset := Form1.AdoConnection1.Commands[0].Execute;
    Form1.Label1.Caption := Inttostr( Form1.ADOdataset1.Recordset.RecordCount );

    if Form1.ADODataSet1.Recordset.EOF = FALSE then
    begin
      Form1.Adodataset1.Recordset.MoveFirst; //  combobox  
      Form1.Combobox1.Clear();
      for i := 0 to Form1.Adodataset1.Recordset.RecordCount - 1 do
      begin

        Form1.Combobox1.Items.Add(Form1.Adodataset1.Recordset.Fields[0].Value);
        Form1.Adodataset1.Recordset.MoveNext

      end;
      Form1.Combobox1.Text := Form1.Combobox1.Items[0];
    end
    else
      MessageDlg('Connection Failed. Please, execute WinCC or Archive Connector.',mtError,[mbOk],0);
  except
    on E : EOleException do
      ShowMessage('Database Connection Failed.');
  end;
end;

procedure TForm1.UpdateClasses();
var
  i: Byte;
  re1,re2: TRegExpr;
  cur, last: String;
begin
  re1 := TRegExpr.Create;
  re2 := TRegExpr.Create;
  re1.Expression := '^(.+)?(_\d{12}){2}$';
  re2.Expression := '^(.+)?(_\d{12})$';

  last := '';

  try
    Form1.ADOConnection1.Close;
    Form1.ADOConnection1.ConnectionString := Form1.Edit1.Text;

    Form1.ADODataSet1.Recordset := Form1.AdoConnection1.Commands[0].Execute;
    Form1.Label1.Caption := Inttostr( Form1.ADOdataset1.Recordset.RecordCount );

    if Form1.ADODataSet1.Recordset.EOF = FALSE then
    begin
      Form1.Adodataset1.Recordset.MoveFirst; //  combobox  
      Form1.Combobox1.Clear();
      for i := 0 to Form1.Adodataset1.Recordset.RecordCount - 1 do
      begin
        if (re1.Exec(Form1.Adodataset1.Recordset.Fields[0].Value)) then
          cur := re1.Match[1]
        else if (re2.Exec(Form1.Adodataset1.Recordset.Fields[0].Value)) then
          cur := re2.Match[1]
        else
          cur := Form1.Adodataset1.Recordset.Fields[0].Value;

        if (cur <> last) then
        begin
          Form1.Combobox1.Items.Add(cur);
          last := cur;
        end;
        Form1.Adodataset1.Recordset.MoveNext
      end;
      Form1.Combobox1.Text := Form1.Combobox1.Items[0];
    end
    else
      MessageDlg('Connection Failed. Please, execute WinCC or Archive Connector.',mtError,[mbOk],0);
  except
    on E : EOleException do
      ShowMessage('Database Connection Failed.');
  end;

  re1.Destroy;
  re2.Destroy;
end;

procedure TForm1.GetClassDatabases(clname: String; names: TStrings);
var
  i: Byte;
  ds: TAdoDataSet;
begin
try
  ds := TADODataset.Create(self);
  ds.ConnectionString := Form1.Edit1.Text;
  ds.CommandText := 'SELECT RTRIM( name),dbid FROM sysdatabases ORDER by ''name''';
  ds.Active:=True;

  if ds.Recordset.EOF = FALSE then
  begin
    ds.Recordset.MoveFirst;
    names.BeginUpdate;
    try
      for i := 0 to ds.Recordset.RecordCount - 1 do
      begin
        if Pos(clname, ds.Recordset.Fields[0].Value) = 1 then
        begin
          names.Add(ds.Recordset.Fields[0].Value);
        end;
        ds.Recordset.MoveNext;
      end;
    finally
      names.EndUpdate;
    end;
  end;
  finally
   ds.Destroy;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  AdoConnection1.Commands[0].CommandText := 'SELECT RTRIM( name),dbid FROM sysdatabases WHERE ((name LIKE ''CC%'') and (name LIKE ''%R'')) or (name LIKE ''AC%'')';
  UpdateDatabases();
//Button2.Enabled:=false;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  AdoConnection1.Commands[0].CommandText := 'SELECT RTRIM( name),dbid FROM sysdatabases';
  UpdateDatabases();
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  AdoConnection1.Commands[0].CommandText := 'SELECT RTRIM( name),dbid FROM sysdatabases WHERE ((name LIKE ''CC%'') and (name LIKE ''%R'')) or (name LIKE ''AC%'') ORDER by name';
  UpdateClasses();
end;



procedure TForm1.EngineLoad(Sender: TObject);
begin
  UpdateServers();
end;


procedure TForm1.Button1Click(Sender: TObject);
begin
  if length(ComboBox1.Text)>15 then begin
      Form2.Caption := ComboBox1.Text;
      Form2.Show;
  end
  else
    MessageDlg('Invalid name of WinCC Database',mtError,[mbOk],0);;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
{
 if length(ADOConnection1.ConnectionString)<10 then
//     ADOConnection1.ConnectionString,       
//   .

     ADOConnection1.ConnectionString := 'Provider=SQLOLEDB.1;' +
                           'Integrated Security=SSPI;' +
  //                         'Persist Security Info=False;'
                           'Initial Catalog=master;' +
                           'Data Source=.\WINCC;'+
  //                         'Use Procedure for Prepare=1;'
                           'Auto Translate=True;'+
                           'Packet Size=4096;';
  //                         'Workstation ID=WINCC_CL1;'
  //                         'Use Encryption for Data=False;'
  //                         'Tag with column collation when possible=False';
  ;}
end;

procedure TForm1.Activate(Sender: TObject);
begin
  if length(ADOConnection1.ConnectionString)<10 then
  begin
    Form1.Edit1.Text :=     'Provider=SQLOLEDB.1;Integrated Security=SSPI;Auto Translate=True;Packet Size=4096;Initial Catalog=master;Data Source=.\WINCC;';
  //                         'Persist Security Info=False;'
  //                         'Use Procedure for Prepare=1;'
  //                         'Workstation ID=WINCC_CL1;'
  //                         'Use Encryption for Data=False;'
  //                         'Tag with column collation when possible=False';
    Form1.Edit2.Text :=     'Provider=WinCCOLEDBProvider.1;Data Source=.\WinCC;';
    UpdateClasses();
  end;
end;


procedure TForm1.EngineSelect(Sender: TObject);
var
  i,j: Integer;
  str: String;

  function NextPos(SearchStr, Str: string; Position: Integer): Integer;
  begin
    Delete(Str, 1, Position - 1);
    Result := Pos(SearchStr, upperCase(Str));
    if Result = 0 then Exit;
    if (Length(Str) > 0) and (Length(SearchStr) > 0) then
      Result := Result + Position + 1;
  end;
begin
  str:=Form1.Edit1.Text;

  i:=Pos('Data Source', str);
  if (i > 0) then
  begin
    j:=NextPos(';', str, i+1);
    if (j > 0) then
    begin
      Delete(str, i, (j-i-1));
    end;
  end;
  Insert('Data Source=' + ComboBox2.Text + ';', str, length(str)+1);
  Form1.Edit1.Text:=str;

  str:=Form1.Edit2.Text;
  i:=Pos('Data Source', str);
  if (i > 0) then
  begin
    j:=NextPos(';', str, i+1);
    if (j > 0) then
    begin
      Delete(str, i, (j-i-1));
    end;
  end;
  Insert('Data Source=' + ComboBox2.Text + ';', str, length(str)+1);
  Form1.Edit2.Text:=str;
end;


end.
