pthread_mutex_t Buffer_mutex = PTHREAD_MUTEX_INITIALIZER;

struct ReaderBuf {
	unsigned char state;
	unsigned int readerpos;
	unsigned int analyzerpos;
	struct ReaderBuf *next;
	
	unsigned char x[buffersize];
	unsigned char y[buffersize];
} *rb = NULL, *rbr=NULL;


int Add2Buffer(int x, int y) {
	pthread_mutex_lock(&Buffer_mutex);
	if ((!rb)||(rb->readerpos==rb->analyzerpos)) {
		if (rb) {
			rb->state=2;
			rb->next=(struct ReaderBuf*)malloc(sizeof(struct ReaderBuf));
			rb=rb->next;
		} else {
			rb=(struct ReaderBuf*)malloc(sizeof(struct ReaderBuf));
			rbr=rb;
		}		
		
		if (!rb) {
			pthread_mutex_lock(&ERROR_mutex);
			ERROR|=ERR_MEM;
			pthread_mutex_unlock(&ERROR_mutex);
			pthread_mutex_unlock(&Buffer_mutex);
			return ERR_MEM;
		}
		rb->next=NULL;
		rb->readerpos=0;
		rb->analyzerpos=0;
		rb->state=1;
	} 
	rb->x[rb->readerpos]=x;
	rb->y[rb->readerpos]=y;
	if (++(rb->readerpos)==buffersize) rb->readerpos=0;
	pthread_mutex_unlock(&Buffer_mutex);
	return 0;
}


int Buffer2Analyzer() {
	struct ReaderBuf *tmp;
	unsigned int newpos;
	signed char x,y;

	pthread_mutex_lock(&Buffer_mutex);
	if (ERROR) {
		pthread_mutex_unlock(&Buffer_mutex);
		return 0;
	}
	
	if ((!rbr)||(rbr->analyzerpos==rbr->readerpos)) {
		if ((!rbr)||(!rbr->state)) {
			pthread_mutex_unlock(&Buffer_mutex);
			return 0;
		}
		if (rbr->state==2) {
			tmp=rbr;
			rbr=rbr->next;
			free(tmp);
		} 	
	}
	x=rbr->x[rbr->analyzerpos];
	y=rbr->y[rbr->analyzerpos];
	rbr->analyzerpos++;
	if (rbr->analyzerpos==buffersize) rbr->analyzerpos=0;
	if (rbr->analyzerpos==rbr->readerpos) rbr->state=0;
	pthread_mutex_unlock(&Buffer_mutex);
	AnalyzeEvent(x,y);
	return 1;
}

int Buffer2AnalyzerAll() {
	while (Buffer2Analyzer());
	return ERROR;
}
