#include "virables.h"
/* ================================ GMode  ================================= */
gmode::gmode(Work *iwrk) : QWidget()
{
    headx=60;
    heady=60;
    wrk=iwrk;
    NNSet=wrk->work->NNSet;
    maxx=wrk->Config->DisplayEvents;
    setFixedSize(maxx+headx,100+heady);
    show();
    iter=0;
    pDevice=new QPainter();
    pDevice->begin(this);
    pDevice->setPen(QColor(200,0,0));
    color=wrk->grp->color;
    _setmaxy=&gmode::setmaxy;
    _init=&gmode::init;
    _clear=&gmode::clear;
    _draw=&gmode::draw;
    _calc=&gmode::calc;    
}

gmode::~gmode()
{

    pDevice->end();
    delete pDevice;
}

void gmode::clear()
{
    iter=0;
    pDevice->eraseRect(0,0,maxx+headx,100+heady);
}

void gmode::init()
{
    char stmp[40];
    (this->*_setmaxy)();
    pDevice->setPen(QColor(0,0,0));
    pDevice->drawLine(1,95+heady,maxx+headx,95+heady);
    pDevice->drawLine(headx-5,5,headx-5,100+heady);
    pDevice->setPen(QColor(0,0,150));
    gcvt((double)maxy,2,stmp);
    pDevice->drawText(1,10,stmp);
    pDevice->setPen(QColor(200,0,0));
}

void gmode::calc()
{
	ftmp=NNSet->Quality[NNSet->rTable[0]];
}

void gmode::setmaxy()
{
	maxy=ftmp;
}

void gmode::draw()
{
    pDevice->drawPoint(headx+iter-5,5+100-(unsigned int)(100*ftmp/maxy));
}

void  gmode::newevent()
{
    (this->*_calc)();
    if (iter==maxx) (this->*_clear)();
    if (iter==1) (this->*_init)();
    (this->*_draw)();
    iter++;
}

/* ================================ GMode 1 (BEST) ========================= */
gmode1::gmode1(Work *iwrk) : gmode(iwrk) { }
/* ================================ GMode 2 (mead) ========================= */
gmode2::gmode2(Work *iwrk) : gmode(iwrk) 
{ 
    _setmaxy=(void (gmode::*)())&gmode2::setmaxy;
    _calc=(void (gmode::*)())&gmode2::calc;    
}

void gmode2::setmaxy()
{
    maxy=ftmp*1.5;
}

void gmode2::calc()
{
    ftmp=0; 
    for (unsigned i=0;i<NNSet->kNNet;i++)
	ftmp+=NNSet->Quality[NNSet->rTable[i]];
}
/* ================================ GMode 4 (BESTs) ========================= */
gmode4::gmode4(Work *iwrk) : gmode(iwrk) 
{ 
    num=misc::Min(NNSet->kNNet,(unsigned int)wrk->Config->ShowBests);
    _setmaxy=(void (gmode::*)())&gmode4::setmaxy;
    _draw=(void (gmode::*)())&gmode4::draw;
}

void gmode4::setmaxy()
{
    maxy=misc::Min(3*NNSet->Quality[NNSet->rTable[0]],NNSet->Quality[NNSet->rTable[num-1]]);
}
void gmode4::draw()
{
    for (unsigned i=0;i<num;i++)
    {
	pDevice->setPen(color[i]);
	pDevice->drawPoint(headx+iter-5,5+100-(unsigned int)(100*NNSet->Quality[NNSet->rTable[i]]/maxy));
    }
}

/* ================================ GMode 5 (WORSTs) ========================= */
gmode5::gmode5(Work *iwrk) : gmode(iwrk) 
{ 
    num=misc::Min(NNSet->kNNet,(unsigned int)wrk->Config->ShowBests);
    _setmaxy=(void (gmode::*)())&gmode5::setmaxy;
    _draw=(void (gmode::*)())&gmode5::draw;
}

void gmode5::setmaxy()
{
    maxy=misc::Max(3*NNSet->Quality[NNSet->rTable[NNSet->kNNet-num]],1.3*NNSet->Quality[NNSet->rTable[NNSet->kNNet-1]]);
}
void gmode5::draw()
{
    for (unsigned i=NNSet->kNNet-num;i<NNSet->kNNet;i++)
    {
	pDevice->setPen(color[i]);
	pDevice->drawPoint(headx+iter-5,5+100-(unsigned int)(100*NNSet->Quality[NNSet->rTable[i]]/maxy));
    }
}