#include "consolevirables.h"
unsigned int 		*lkIn;
unsigned int 		*lkOut;
unsigned long  int 	*lkID;
unsigned int 		lAct;

#include "nfunc.h"
#include "nfuncset.h"
Main *work;

/* =================== Connection functions ================================*/
    void Connection::SendToConnection(BaseFloatType Input)
    {
	InValue=Input;
    }

    BaseFloatType Connection::GetFromConnection()
    {
	OutValue=TFunction(InValue,Weight[lAct]);
	return OutValue;
    }
/* ================== Neuron functions ======================================*/	
    void Neuron::GetFromConnections()
    {
	for (unsigned i=0;i<InNumber;i++)
	    InValue[i]=InConnection[i]->GetFromConnection();
	Value=InFunction(InNumber, InValue);
    }
    void Neuron::SendToConnections()
    {
	OutValue=OutFunction(Value,Weight[lAct]);
	for (unsigned i=0;i<OutNumber;i++)
	    OutConnection[i]->SendToConnection(OutValue);
    }

/* ================== NNetwork functions ================================== */
NNetwork::NNetwork(ConsoleInit *icf,NNetSet *iNNSet)
{
    FILE *f;
    unsigned i,j,k,ii;
    unsigned long pos;
    char c;
    char s[99];
    
    cf=icf;
    f=fopen(cf->ncfn,"r");
    NNSet=iNNSet;
    misc::SkipComment(f);
    fscanf(f,"%u",&kNeu);	/* Number of Neurons in NET Configuration */
    fgets(s,99,f);misc::SkipComment(f);
    fscanf(f,"%u",&kCon);
    fgets(s,99,f);
    Neu=new Neuron[kNeu];
    Con=new Connection[kCon];
    for (i=0;i<kNeu;i++)	/* Seting NEURONs setings */
    {
	misc::SkipComment(f);
	fscanf(f,"%u",&j);j--; /* In file from 1, in C++ from 0 */
	fscanf(f,"%s",s);
	Neu[j].SetInFunction(s);
	fscanf(f,"%s",s);
	Neu[j].SetOutFunction(s);
	fgets(s,99,f);
	Neu[j].OutNumber=0;
	Neu[j].InNumber=0;
	Neu[j].Weight=new BaseFloatType[cf->MaxNNet];
    }

    pos=ftell(f);
    kIn=0;kOut=0;
    for (ii=0;ii<kCon;ii++)
    {					/* Calculating number of Connections */
	misc::SkipComment(f);
        fscanf(f,"%u",&i);i--;
        fscanf(f,"%u",&j);j--;
        fscanf(f,"%s",s);
        fgets(s,99,f);
        if (i<30000) Neu[i].OutNumber++;
        else kIn++;
        if (j<30000) Neu[j].InNumber++;
        else kOut++;
    }
    In=new Connection*[kIn];
    Out=new Connection*[kOut];
    kIn=0;
    kOut=0;

    for (i=0;i<kNeu;i++)	/* Getting memory */
    {
	Neu[i].InConnection=new Connection*[Neu[i].InNumber];
	Neu[i].InValue=new BaseFloatType[Neu[i].InNumber];
	Neu[i].OutConnection=new Connection*[Neu[i].OutNumber];
	Neu[i].InNumber=0;
	Neu[i].OutNumber=0;
    }
    fseek(f,pos,SEEK_SET);
    for (k=0;k<kCon;k++)	/* Setting up Connections */
    {
	misc::SkipComment(f);
	fscanf(f,"%u",&i);i--;
	fscanf(f,"%u",&j);j--;
	fscanf(f,"%s",s);
	if (i<30000) 
	{
	    Neu[i].OutConnection[Neu[i].OutNumber]=&Con[k];
	    Neu[i].OutNumber++;
	    Con[k].from=&Neu[i];
	    Con[k].type=0;
	}
	else 
	{
	    In[kIn]=&Con[k];
	    kIn++;
	    Con[k].from=NULL;
	    Con[k].type=1;
	}
	if (j<30000)
	{
	    Neu[j].InConnection[Neu[j].InNumber]=&Con[k];
	    Neu[j].InNumber++;
	    Con[k].to=&Neu[j];
	}
	else
	{
	    Out[kOut]=&Con[k];
	    kOut++;
	    Con[k].to=NULL;
	    Con[k].type=2;
	}
	Con[k].SetTFunction(s);
	Con[k].Weight=new BaseFloatType[cf->MaxNNet];
	fgets(s,99,f);
    }
    fclose(f);
}

NNetwork::~NNetwork()
{
    unsigned i;
    for (i=0;i<kNeu;i++)
    {
	delete Neu[i].Weight;
	delete Neu[i].InValue;
    }
    for (i=0;i<kCon;i++)
	delete Con[i].Weight;
    delete In;
    delete Out;	
    delete Neu;
    delete Con;
}

void NNetwork::NetCalc(BaseFloatType *InputData, BaseFloatType *OutputData)
{
    unsigned int i;
    lAct=NNSet->rTable[NNSet->cParam];
    for (i=0;i<kIn;i++)
	In[i]->SendToConnection(InputData[i]);
    for (i=0;i<kNeu;i++)
    {
	Neu[i].GetFromConnections();
	Neu[i].SendToConnections();
    }
    for (i=0;i<kOut;i++)
	OutputData[i]=Out[i]->GetFromConnection();
}

unsigned NNetwork::ifConAtachedNeu(unsigned int con, unsigned int neu)
{
    if ((Con[con].from==&Neu[neu])||(Con[con].to==&Neu[neu])) return 1;
    return 0;
}

/* =========================== NNetSet functions =========================== */

NNetSet::NNetSet(ConsoleInit *icf, Main *imain)
{
    cf=icf;
    main=imain;
    rTable=new unsigned int[cf->MaxNNet];
    Old=new long int[cf->MaxNNet];
    pt=new unsigned char[cf->MaxNNet];
    for (unsigned i=0;i<cf->MaxNNet;i++)
    {
	rTable[i]=i;
	Old[i]=0;
	pt[0]=0;
    }
    cParam=0;
    kNNet=cf->kNNet;
    NNet=new NNetwork(cf,this);
    OutputData=new BaseFloatType[NNet->kOut];
    Quality=new BaseFloatType[cf->MaxNNet];
    SetQiFunction(cf->Qi);
    DropFlag=0;
    if (cf->CV) main->SaveNeuron=new BaseFloatType[NNet->kNeu+NNet->kCon];
    if (cf->LoadFn[0]==0) InitialiseData();
    else LoadData(cf->LoadFn);
}
NNetSet::~NNetSet()
{
    delete Quality;
    delete OutputData;
    delete NNet;
    delete rTable;
    delete Old;
    delete pt;
}

void NNetSet::CopyNeuron(unsigned int from, unsigned int to, unsigned int Type, unsigned int num)
{
    if (Type==0)
	NNet->Neu[num].Weight[rTable[to]]=NNet->Neu[num].Weight[rTable[from]];
    else
	NNet->Con[num].Weight[rTable[to]]=NNet->Con[num].Weight[rTable[from]];
}


void NNetSet::CorelateNeuron(unsigned char Type, unsigned int num, unsigned int Base, unsigned int NumNNet, unsigned char mode)
{
    if (Type==0)
    {
	if (misc::Random(2)==1)
	{
	    if (mode==0)
		NNet->Neu[num].Weight[rTable[NumNNet]]=NNet->Neu[num].Weight[rTable[Base]]*(1+misc::Random(cf->CrlUp));
	    else if (mode==1)
		NNet->Neu[num].Weight[rTable[NumNNet]]=NNet->Neu[num].Weight[rTable[Base]]*(1+misc::Random(cf->pCrlUp));
	    else
		NNet->Neu[num].Weight[rTable[NumNNet]]=NNet->Neu[num].Weight[rTable[Base]]*(1+misc::Random(cf->spCrlUp));
	}
	else
	{
	    if (mode==0)
		NNet->Neu[num].Weight[rTable[NumNNet]]=NNet->Neu[num].Weight[rTable[Base]]*(1-misc::Random(cf->CrlUp));
	    else if (mode==1)
		NNet->Neu[num].Weight[rTable[NumNNet]]=NNet->Neu[num].Weight[rTable[Base]]*(1-misc::Random(cf->pCrlUp));
	    else
		NNet->Neu[num].Weight[rTable[NumNNet]]=NNet->Neu[num].Weight[rTable[Base]]*(1-misc::Random(cf->spCrlUp));
	}
    }
    else 
    {
	if (misc::Random(2)==1)
	{
	    if (mode==0)
		NNet->Con[num].Weight[rTable[NumNNet]]=NNet->Con[num].Weight[rTable[Base]]*(1+misc::Random(cf->CrlUp));
	    else if (mode==1)
		NNet->Con[num].Weight[rTable[NumNNet]]=NNet->Con[num].Weight[rTable[Base]]*(1+misc::Random(cf->pCrlUp));
	    else
		NNet->Con[num].Weight[rTable[NumNNet]]=NNet->Con[num].Weight[rTable[Base]]*(1+misc::Random(cf->spCrlUp));
	}
	else
	{
	    if (mode==0)
		NNet->Con[num].Weight[rTable[NumNNet]]=NNet->Con[num].Weight[rTable[Base]]*(1-misc::Random(cf->CrlUp));
	    else if (mode==1)
		NNet->Con[num].Weight[rTable[NumNNet]]=NNet->Con[num].Weight[rTable[Base]]*(1-misc::Random(cf->pCrlUp));
	    else
		NNet->Con[num].Weight[rTable[NumNNet]]=NNet->Con[num].Weight[rTable[Base]]*(1-misc::Random(cf->spCrlUp));
	}
    }
}

void NNetSet::InitialiseWeight(unsigned char Type, unsigned int Num, unsigned int NumNNet)
{		/* Type 0 - Neu 1 - Con */
    if (cf->imNNet_==0)				/* Full Random */
    {
	if (Type==0)
	    NNet->Neu[Num].Weight[rTable[NumNNet]]=misc::Random(cf->imFrom[0][0],cf->imTo[0][0]);
	else
	    NNet->Con[Num].Weight[rTable[NumNNet]]=misc::Random(cf->imFrom[0][0],cf->imTo[0][0]);
    }
    else if (cf->imNNet_==1)			/* Random */
    {
	if (Type==0)
	    NNet->Neu[Num].Weight[rTable[NumNNet]]=misc::Random(cf->imFrom[0][Num],cf->imTo[0][Num]);
	else 
	    NNet->Con[Num].Weight[rTable[NumNNet]]=misc::Random(cf->imFrom[0][Num+NNet->kNeu],cf->imTo[0][Num+NNet->kNeu]);
    }
    else if (cf->imNNet_==2)			/* Read */
    {
	if (Type==0)
	    NNet->Neu[Num].Weight[rTable[NumNNet]]=cf->imFrom[0][Num];
	else
	    NNet->Con[Num].Weight[rTable[NumNNet]]=cf->imFrom[0][Num+NNet->kNeu];
    }
    else if (cf->imNNet_==3)			/* Dif Full Random */
    {
	if (Type==0)
	    NNet->Neu[Num].Weight[rTable[NumNNet]]=misc::Random(cf->imFrom[0][NumNNet],cf->imTo[0][NumNNet]);
	else 
	    NNet->Con[Num].Weight[rTable[NumNNet]]=misc::Random(cf->imFrom[0][NumNNet],cf->imTo[0][NumNNet]);
    }
    else if (cf->imNNet_==4)			/* Dif Random */
    {
	if (Type==0)
	    NNet->Neu[Num].Weight[rTable[NumNNet]]=misc::Random(cf->imFrom[NumNNet][Num],cf->imTo[NumNNet][Num]);
	else 
	    NNet->Con[Num].Weight[rTable[NumNNet]]=misc::Random(cf->imFrom[NumNNet][Num+NNet->kNeu],cf->imTo[NumNNet][Num+NNet->kNeu]);
    }
    else  /* if (cf->imNNet_==5) */		/* Dif Read */
    {
	if (Type==0)
	    NNet->Neu[Num].Weight[rTable[NumNNet]]=cf->imFrom[NumNNet][Num];
	else
	    NNet->Con[Num].Weight[rTable[NumNNet]]=cf->imFrom[NumNNet][Num+NNet->kNeu];
    }
}

void NNetSet::InitialiseNNet(unsigned int NumNNet)
{
    unsigned j;
    for (j=0;j<NNet->kNeu;j++) InitialiseWeight(0,j,NumNNet);
    for (j=0;j<NNet->kCon;j++) InitialiseWeight(1,j,NumNNet);
}

void NNetSet::InitialiseData()
{
	for (unsigned i=0;i<kNNet;i++)
	    InitialiseNNet(i);
}
void NNetSet::LoadNNet(unsigned int NumNNet, FILE *f)
{
    unsigned j;
    float ftemp;
    
    for (j=0;j<NNet->kNeu;j++) 
    {
	fscanf(f,"%f",&ftemp); 
	NNet->Neu[j].Weight[rTable[NumNNet]]=(BaseFloatType)ftemp;
    }
    for (j=0;j<NNet->kCon;j++)
    {
	fscanf(f,"%f",&ftemp);
	NNet->Con[j].Weight[rTable[NumNNet]]=(BaseFloatType)ftemp;
    }
}

		
void NNetSet::LoadData(const char *fname)
{
    FILE *f;
    char tmp[80];
    unsigned aNNet;
    unsigned i;
    unsigned CVSaved;
    float ftemp;
    
    f=fopen(fname,"r");
    fgets(tmp,80,f);
    fscanf(f,"%u",&aNNet);
    fscanf(f,"%u",&CVSaved);
    if (aNNet>cf->MaxNNet) aNNet=cf->MaxNNet;
    for (i=0;i<aNNet;i++)
	LoadNNet(i,f);
    if ((cf->CV)&&(CVSaved))
    {
	for (i=0;i<NNet->kNeu+NNet->kCon;i++)
	{
	    fscanf(f,"%f",&ftemp);
	    main->SaveNeuron[i]=(BaseFloatType)ftemp;
	}
	fscanf(f,"%f",&ftemp);
	main->CVQuality=ftemp;
	fscanf(f,"%u",&i);
	main->SaveNeuronProduced=i;

    }
    fclose(f);
    if (aNNet<kNNet)
	for (;i<kNNet;i++)
	    InitialiseNNet(i);
    else if (aNNet>kNNet)
    {
	DropFlag=kNNet;
	kNNet=aNNet;
    }
}


int SortFunction(const void *a, const void *b)
{
    if (work->NNSet->Quality[*(unsigned int*)a]<work->NNSet->Quality[*(unsigned int*)b]) return -1;
    else if (work->NNSet->Quality[*(unsigned int*)a]>work->NNSet->Quality[*(unsigned int*)b]) return 1;
    else return 0;
}

void NNetSet::Sort()
{
    qsort((void*)rTable,(unsigned)kNNet,sizeof(unsigned int),&SortFunction);
}

BaseFloatType NNetSet::TestNeurons(unsigned char Type, unsigned int num, unsigned int w1, unsigned int w2)
{
    if (Type==0)
	return ( fabs((NNet->Neu[num].Weight[w1]-NNet->Neu[num].Weight[w2])/NNet->Neu[num].Weight[w1]));
    else
	return ( fabs((NNet->Con[num].Weight[w1]-NNet->Con[num].Weight[w2])/NNet->Con[num].Weight[w1]));
}

unsigned char NNetSet::TestNNets(unsigned int w1, unsigned int w2)
{	/* 0 - Okey 1 - Bad */
    unsigned int i,j;
    BaseFloatType zn,max=0,sum=0;
    
    for (i=0;i<NNet->kNeu;i++)
    {
	if ((cf->kDisable<=i)||(cf->Disable[i]!=0)) 
	{
	    zn=100*TestNeurons(0,i,w1,w2);
	    if (zn<cf->nDist) return 1;
	    else 
	    {
		if (zn>max) max=zn;
		sum+=zn;
	    }
	}
    }    
    for (i=0;i<NNet->kCon;i++)
    {
	if ((cf->kDisable<=i+NNet->kNeu)||(cf->Disable[i+NNet->kNeu]!=0)) 
	{
	    zn=100*TestNeurons(1,i,w1,w2);
	    if (zn<cf->nDist) return 1;
    	    else 
	    {
		if (zn>max) max=zn;
		sum+=zn;
	    }
	}
    }
    if (sum<cf->nnDist) return 1;
    if (max<cf->pnDist) return 1;
    return 0;
}

unsigned char NNetSet::TestEqual(unsigned int w2)
{
    for (unsigned i=0;i<w2;i++)
	if ((Old[rTable[i]]>=0)&&(TestNNets(rTable[i],rTable[w2])==1)) return 1;
    return 0;
}
	    	
void NNetSet::DropEquals(unsigned int okNNet)
{
    unsigned int i, utemp;
    unsigned int ig=0,in=0;
    unsigned int kn=0,ko=0,ka=0;
    unsigned int a;
    unsigned int mn,mo,ma;
    unsigned int o=(unsigned int)(okNNet*cf->oStay/100);
    unsigned int n=(unsigned int)(okNNet*cf->nStay/100);
    for (i=0;i<kNNet;i++)
    {
	if (TestEqual(i)==1)
	    Old[rTable[i]]=-1;
	else if ((cf->oDelete!=0)&&(Old[rTable[i]]>cf->oDelete)) Old[rTable[i]]=-2;
	else if ((cf->oStay==0)&&(Old[rTable[i]]==0)) ko++;
	else if ((cf->oStay!=0)&&(Old[rTable[i]]>cf->oStay)) ko++;
	else if (Old[rTable[i]]==1) kn++;
	else ka++;
    }
    
    mn=misc::Min(n,kn);
    mo=misc::Min(o,ko);
    ma=misc::Min(okNNet-mo-mn,ka+misc::abs0(kn-n)+misc::abs0(ko-o));
    a=okNNet-mn-mo-ma;
			    /* Now mo,mn,ma,a contains 
			    mo - maximal number of old
			    mn - maximal number of new
			    ma - maximal number of other
			    a - number to generate new */
    ko=0;kn=0;ka=0;ig=1/*0*/;in=1/*0*/;
    while ((ig<okNNet)&&(in<kNNet)) 
    {
	if (Old[rTable[in]]>=0)
	{
	    if (((cf->oStay==0)&&(Old[rTable[in]]==0))||((cf->oStay!=0)&&(Old[rTable[in]]-1>cf->oStay)))
	    {
		if (ko<mo)
	    	{
		    utemp=rTable[in];
		    rTable[in]=rTable[ig];
		    rTable[ig]=utemp;
		    ko++;
		    ig++;
		}
		else if (ka<ma)
	        {
		    utemp=rTable[in];
	    	    rTable[in]=rTable[ig];
		    rTable[ig]=utemp;
		    ka++;
		    ig++;
		}
	    }
	    else if (Old[rTable[in]]==1)
	    {
		if (kn<mn)
		{
		    utemp=rTable[in];
		    rTable[in]=rTable[ig];
		    rTable[ig]=utemp;
		    kn++;
		    ig++;
		}
		else if (ka<ma)
		{
		    utemp=rTable[in];
		    rTable[in]=rTable[ig];
		    rTable[ig]=utemp;
		    ka++;
		    ig++;
		}
	    }
	    else
	    {
		if (ka<ma)
		{
		    utemp=rTable[in];
    		    rTable[in]=rTable[ig];
		    rTable[ig]=utemp;
		    ka++;
		    ig++;
		}
	    }
	}
	in++;
    }
    in=ig;
    for (;ig<okNNet;ig++)
    {
	InitialiseNNet(ig);
	Old[rTable[ig]]=1;
	pt[rTable[ig]]=0;
    }
    main->GetQualites(in,ig);
}	

void NNetSet::Drop(unsigned char RequireSorting, unsigned int okNNet)
{
    if (cf->gbMet==0) /* Take Best */
    {
	if (RequireSorting) Sort();
	DropEquals(okNNet);
	kNNet=okNNet;
    }
    DropFlag=0;
}

		
void NNetSet::ShowInfo()
{
/*    unsigned i,j,ii;
    for (i=0;i<kNNet;i++)
    {
	for (j=0;j<NNet->kNeu;j++)
	    printf("%e ",(float)NNet->Neu[j].Weight[rTable[i]]);
	printf(",");
	for (j=0;j<NNet->kCon;j++)
	    printf("%e ",(float)NNet->Con[j].Weight[rTable[i]]); 
	printf("\n%e : %i %u\n", (float)Quality[rTable[i]], Old[rTable[i]],pt[rTable[i]]);
        cParam=i;
	for (j=0;j<cf->kID;j++)
	{
	    for (ii=0;ii<NNet->kIn;ii++)
		printf("%f ",(float)main->TestData[j][ii]);
	    printf("- ");
	    NNet->NetCalc(main->TestData[j],OutputData);
	    for (ii=0;ii<NNet->kOut;ii++)
		printf("%f ",(float)OutputData[ii]);
	    printf("\n");
	}
    }
    printf("\n\n");*/
}
	
void NNetSet::Randomize(unsigned int i, unsigned int BasedOnNNet, unsigned int AdvNum)
{
    unsigned j,i1;

    if (cf->RndMax!=0) j=misc::Random(cf->RndMin,cf->RndMax);
    else j=misc::Random(cf->RndMin,NNet->kCon+NNet->kNeu);
    
    for (i1=0;i1<NNet->kNeu;i1++)
    {
	if (((!cf->AdvNeu)&&(misc::Random(NNet->kCon+NNet->kNeu)<j))||((cf->AdvNeu)&&(AdvNum==i1)))
	    if ((cf->kDisable<i1)||((cf->Disable[i1]==1)||(cf->Disable[i1]==5))) 
		    InitialiseWeight(0,i1,i);
	    else
	    {
		    CopyNeuron(BasedOnNNet,i,0,i1);
		    j+=1;
	    }
	else
	    CopyNeuron(BasedOnNNet,i,0,i1);
    }
    for (i1=0;i1<NNet->kCon;i1++)
	if (((!cf->AdvNeu)&&(misc::Random(NNet->kCon+NNet->kNeu)<j))||((cf->AdvNeu)&&(NNet->ifConAtachedNeu(i1,AdvNum))))
	    if ((cf->kDisable<i1+NNet->kNeu)||((cf->Disable[i1+NNet->kNeu]==1)
				||(cf->Disable[i1+NNet->kNeu]==5))) 
		InitialiseWeight(1,i1,i);
	    else
	    {
		CopyNeuron(BasedOnNNet,i,1,i1);
		j+=1;
	    }
	else 
	    CopyNeuron(BasedOnNNet,i,1,i1);
    pt[rTable[i]]=0;
}


void NNetSet::Corelate(unsigned int i, unsigned int BasedOnNNet, unsigned int AdvNum)
{
    unsigned i1,j;
    unsigned char mode,pttemp;
    
    pttemp=0;
    if (misc::Random(100.)<cf->pCrl) mode=1;
    else mode=0;
    if (cf->CrlMax!=0) j=misc::Random(cf->CrlMin,cf->CrlMax);
    else j=misc::Random(cf->CrlMin,NNet->kCon+NNet->kNeu);
    for (i1=0;i1<NNet->kNeu;i1++)
	if ((cf->kDisable>i1)&&(cf->Disable[i1]!=1)&&((cf->Disable[i1]<2)||(cf->Disable[i1]>3)))
	        CopyNeuron(BasedOnNNet,i,0,i1);
	else if (((!cf->AdvNeu)&&(misc::Random(NNet->kCon+NNet->kNeu)<j))||((cf->AdvNeu)&&(AdvNum==i1)))
	{
	    if ((mode==1)&&((cf->kDisable<i1)||(cf->Disable[i1]!=3))) CorelateNeuron(0,i1,BasedOnNNet,i,1);
	    else if ((misc::Random(100.)<cf->spCrl)&&((cf->kDisable<i1)||(cf->Disable[i1]!=3)))
	    {
		CorelateNeuron(0,i1,BasedOnNNet,i,2);
		pttemp=1;
	    }
	    else CorelateNeuron(0,i1,BasedOnNNet,i,0);
	}
	else
	    CopyNeuron(BasedOnNNet,i,0,i1);
    for (i1=0;i1<NNet->kCon;i1++)
    {
	if ((cf->kDisable>i1+NNet->kNeu)&&(cf->Disable[i1+NNet->kNeu]!=1)&&((cf->Disable[i1+NNet->kNeu]<2)||(cf->Disable[i1+NNet->kNeu]>3)))
	        CopyNeuron(BasedOnNNet,i,1,i1);
	else if (((!cf->AdvNeu)&&(misc::Random(NNet->kCon+NNet->kNeu)<j))||((cf->AdvNeu)&&(NNet->ifConAtachedNeu(i1,AdvNum))))
	{
	    if ((mode==1)&&((cf->kDisable<i1+NNet->kNeu)||(cf->Disable[i1+NNet->kNeu]!=3))) CorelateNeuron(1,i1,BasedOnNNet,i,1);
	    else if ((misc::Random(100.)<cf->spCrl)&&((cf->kDisable<i1+NNet->kNeu)||(cf->Disable[i1+NNet->kNeu]!=3))) 
	    {
		CorelateNeuron(1,i1,BasedOnNNet,i,2);
		pttemp=1;
	    }
	    else CorelateNeuron(1,i1,BasedOnNNet,i,0);
	}
	else 
	    CopyNeuron(BasedOnNNet,i,1,i1);
    }
    if (pttemp==1) pt[rTable[i]]=3;
    else if (mode==1) pt[rTable[i]]=2;
    else pt[rTable[i]]=1;
}

void NNetSet::Combine(unsigned int i, unsigned int BasedOnNNet, unsigned int AdvNum)
{
    unsigned int i1,j, BasedOnNNet2;

    unsigned char mode,pttemp;
    pttemp=0;
    
    BasedOnNNet2=misc::Random(kNNet);
    if (cf->CmbMax!=0) j=misc::Random(cf->CmbMin,cf->CmbMax);
    else j=misc::Random(cf->CmbMin,NNet->kCon+NNet->kNeu);

    for (i1=0;i1<NNet->kNeu;i1++)
	if ((cf->kDisable>i1)&&(cf->Disable[i1]!=1)&&(cf->Disable[i1]!=4))
	        CopyNeuron(BasedOnNNet,i,0,i1);
	else if (((!cf->AdvNeu)&&(misc::Random(NNet->kCon+NNet->kNeu)<j))||((cf->AdvNeu)&&(AdvNum==i1)))
	    CopyNeuron(BasedOnNNet2,i,0,i1);
	else
	    CopyNeuron(BasedOnNNet,i,0,i1);

    for (i1=0;i1<NNet->kCon;i1++)
	if ((cf->kDisable>i1+NNet->kNeu)&&(cf->Disable[i1+NNet->kNeu]!=1)&&(cf->Disable[i1+NNet->kNeu]!=4))
	        CopyNeuron(BasedOnNNet,i,1,i1);
	else if (((!cf->AdvNeu)&&(misc::Random(NNet->kCon+NNet->kNeu)<j))||((cf->AdvNeu)&&(NNet->ifConAtachedNeu(i1,AdvNum))))
	    CopyNeuron(BasedOnNNet2,i,1,i1);
	else 
	    CopyNeuron(BasedOnNNet,i,1,i1);

    pt[rTable[i]]=4;
}

void NNetSet::MakeNew()
{
    unsigned int i,j,nkNNet,okNNet,BasedOnNNet,AdvNum;

    nkNNet=(int)(kNNet*(1+cf->pnNNet/100));
    okNNet=kNNet;
    if (nkNNet>cf->MaxNNet) nkNNet=cf->MaxNNet;
    for (i=kNNet;i<nkNNet;i++)
    {
	Old[rTable[i]]=1;
	BasedOnNNet=misc::Random(kNNet);
	if (cf->AdvNeu) AdvNum=misc::Random(NNet->kNeu);
	j=misc::Random(cf->RndWeight+cf->CrlWeight+cf->CmbWeight); 

    	if (j<cf->RndWeight) Randomize(i,BasedOnNNet,AdvNum);
	else if (j<cf->RndWeight+cf->CrlWeight) Corelate(i,BasedOnNNet,AdvNum);
	else  Combine(i,BasedOnNNet,AdvNum);
    }
    kNNet=nkNNet;
    main->GetQualites(okNNet,nkNNet);
    Drop(1, okNNet);
    if (cf->CV) main->CrossValidate();
}

BaseFloatType NNetSet::GetQuality(BaseFloatType *TestData)
{
    NNet->NetCalc(TestData,OutputData);
    lkIn=&NNet->kIn;
    lkOut=&NNet->kOut;
    return (*QualityMinorFunction)(TestData,OutputData);
}

void NNetSet::SaveNNSet(const char *path, const char *comment)
{
    FILE *f;
    unsigned i,j;
    
    f=fopen(path,"w");
    fprintf(f,"%s\n",comment);
    fprintf(f,"%u %u\n",kNNet, cf->CV);
    for (i=0;i<kNNet;i++)
    {
	for (j=0;j<NNet->kNeu;j++)
	    fprintf(f,"%e ",(float)NNet->Neu[j].Weight[rTable[i]]);
	for (j=0;j<NNet->kCon;j++)
	    fprintf(f,"%e ",(float)NNet->Con[j].Weight[rTable[i]]); 
	fprintf(f,"\n");
    }
    if (cf->CV)
    {
	for (j=0;j<NNet->kNeu+NNet->kCon;j++) 
	    fprintf(f,"%e ",(float)main->SaveNeuron[j]);
	fprintf(f,"\n%e ",(float)main->CVQuality);
	fprintf(f,"%u\n",(float)main->SaveNeuronProduced);
    }
    fclose(f);
}

/* =========================== Main functions ============================= */
void Main::ReadTestData()
{
     FILE *f;
    unsigned int i,j;
    char tmp[20];
    float ftmp;
    
    f=fopen(cf->tfn,"r");
    TestData=new BaseFloatType*[cf->kID];
    for (j=0;j<cf->kID;j++)	/* Now I reading all file in Memory */
    {				/* Later May be i change it */
	TestData[j]=new BaseFloatType[NNSet->NNet->kIn+NNSet->NNet->kOut];
	for(i=0;i<NNSet->NNet->kIn+NNSet->NNet->kOut;i++)
	{
	    fscanf(f,"%f",&ftmp); 
	    TestData[j][i]=(BaseFloatType)ftmp;
	}
	fgets(tmp,20,f);
    }
    fclose(f);
}

void Main::ReadControlData()
{
    FILE *f;
    unsigned int i,j;
    char tmp[20];
    float ftmp;
    
    f=fopen(cf->ctfn,"r");
    TestData=new BaseFloatType*[cf->kcID];
    for (j=0;j<cf->kcID;j++)	/* Now I reading all file in Memory */
    {				/* Later May be i change it */
	TestData[j]=new BaseFloatType[NNSet->NNet->kIn+NNSet->NNet->kOut];
	for(i=0;i<NNSet->NNet->kIn;i++)
	{
	    fscanf(f,"%f",&ftmp); 
	    TestData[j][i]=(BaseFloatType)ftmp;
	}
	fgets(tmp,20,f);
    }
    fclose(f);
}
	

Main::Main(ConsoleInit *icf)
{
    work=this;
    cf=icf;
    NNSet=new NNetSet(cf,this);
    Quality=new BaseFloatType[cf->kID];
    CVQuality=1E+15;
    SetQaFunction(cf->Qa);
    if (cf->OnlyCalc) ReadControlData();
    else 
    {
	ReadTestData();
	GetQualites(0,NNSet->kNNet);
    }
    if (NNSet->DropFlag!=0) NNSet->Drop(0,NNSet->DropFlag);
}

Main::~Main()
{
    if (cf->OnlyCalc)
        for (unsigned j=0;j<cf->kcID;j++)
    	    delete TestData[j];
    else
	for (unsigned j=0;j<cf->kID;j++)
	    delete TestData[j];
    delete TestData;
    delete NNSet;
    delete Quality;
    if (cf->CV) delete SaveNeuron;
}    

BaseFloatType Main::GetQuality()
{
    for(unsigned i=0;i<cf->kID;i++)
	Quality[i]=NNSet->GetQuality(TestData[i]);
    lkID=&cf->kID;
    return (*QualityMajorFunction)(Quality);
}

BaseFloatType Main::GetLearnQuality()
{
    unsigned i,j;
    for(i=0,j=0;i<cf->CVStart-1;i++,j++)
	Quality[j]=NNSet->GetQuality(TestData[i]);
    for(i=cf->CVEnd;i<cf->kID;i++,j++)
	Quality[j]=NNSet->GetQuality(TestData[i]);
    lkID=&cf->LrnkID;
    return (*QualityMajorFunction)(Quality);
}

BaseFloatType Main::GetCVQuality()
{
    for (unsigned i=cf->CVStart-1,j=0;i<cf->CVEnd;i++,j++)
	Quality[j]=NNSet->GetQuality(TestData[i]);
    lkID=&cf->CVkID;
    return (*QualityMajorFunction)(Quality);
}

void Main::CrossValidate()
{
    double CVQualityNew;
    unsigned i,j;
    for (j=0;((j<3)&&(j<NNSet->kNNet));j++)
    {
	NNSet->cParam=j;
	CVQualityNew=GetCVQuality();
	if (CVQualityNew<CVQuality)
	{
	    CVQuality=CVQualityNew;
		// Saving New Best Neuron Information
	    for (i=0;i<NNSet->NNet->kNeu;i++)
		SaveNeuron[i]=NNSet->NNet->Neu[i].Weight[NNSet->rTable[j]];
	    for (i=0;i<NNSet->NNet->kCon;i++)
		SaveNeuron[NNSet->NNet->kNeu+i]=NNSet->NNet->Con[i].Weight[NNSet->rTable[j]];
    	    SaveNeuronProduced=NNSet->pt[NNSet->rTable[j]];
	}
    }
}

BaseFloatType Main::GetQualites(unsigned int from, unsigned int to)
{
    for (unsigned i=from;i<to;i++)
    {
	NNSet->cParam=i;
	if ((cf->CV)&&(!cf->OnlyCalc))
	    NNSet->Quality[NNSet->rTable[NNSet->cParam]]=GetLearnQuality();
	else
	    NNSet->Quality[NNSet->rTable[NNSet->cParam]]=GetQuality();
    }
}

void Main::Iterate(unsigned long int k_It)
{
    for (unsigned i=0;i<k_It;i++)
    {
	for (unsigned j=0;j<NNSet->kNNet;j++) 
	    if (NNSet->Old[NNSet->rTable[j]]>0) NNSet->Old[NNSet->rTable[j]]++;
	NNSet->MakeNew();
    }
}

void Main::SaveOutput()
{	
    unsigned i,j,ii;
    FILE *f=fopen(cf->ofn,"w");

    if (cf->CV)
    {
	i=NNSet->kNNet;
	for(ii=0;ii<NNSet->NNet->kNeu;ii++)
	    NNSet->NNet->Neu[ii].Weight[NNSet->rTable[i]]=SaveNeuron[ii];
	for(ii=0;ii<NNSet->NNet->kCon;ii++)
	    NNSet->NNet->Con[ii].Weight[NNSet->rTable[i]]=SaveNeuron[NNSet->NNet->kNeu+ii];
    }
    GetQualites(0,NNSet->kNNet+(cf->CV!=0));
    for (i=0;i<NNSet->kNNet;i++)
	fprintf(f,"Neuron %u with Quality %e, Old %lu, Produced by %u.\n",
		i,
		(float)NNSet->Quality[NNSet->rTable[i]],
		NNSet->Old[NNSet->rTable[i]],
		NNSet->pt[NNSet->rTable[i]]);
    if (cf->CV)
	fprintf(f,"Neuron (CV) with Quality %e, Produced by %u.\n",
		(float)NNSet->Quality[NNSet->rTable[i]],SaveNeuronProduced);
    fprintf(f,"-----------------------------------------------------------\n");
    for (i=0;i<NNSet->kNNet+(cf->CV!=0);i++)
    {
	if (i==NNSet->kNNet) fprintf(f,"CV ");
	NNSet->cParam=i;
	fprintf(f,"Neuron Net %u with Quality %e\n",i,(float)NNSet->Quality[NNSet->rTable[i]]);
	for (j=0;j<cf->kID;j++)
	{
	    for (ii=0;ii<NNSet->NNet->kIn;ii++)
		fprintf(f,"%f ",(float)TestData[j][ii]);
	    fprintf(f,"- ");
	    NNSet->NNet->NetCalc(TestData[j],NNSet->OutputData);
	    for (ii=0;ii<NNSet->NNet->kOut;ii++)
		fprintf(f,"%f ",(float)NNSet->OutputData[ii]);
	    fprintf(f,"\n");
	}
    }
    fclose(f);
}

void Main::SaveResults()
{
    FILE *f;
    unsigned i,j,ii,l;
    char tmp[200];
    char stmp[200]="NewResults/";l=11;
    File::rmf(stmp);
    for (i=0;i<NNSet->kNNet+(cf->CV!=0);i++)
    {
	if (i==NNSet->kNNet)
	{
	    for(ii=0;ii<NNSet->NNet->kNeu;ii++)
		NNSet->NNet->Neu[ii].Weight[NNSet->rTable[i]]=SaveNeuron[ii];
	    for(ii=0;ii<NNSet->NNet->kCon;ii++)
		NNSet->NNet->Con[ii].Weight[NNSet->rTable[i]]=SaveNeuron[NNSet->NNet->kNeu+ii];
	    sprintf(tmp,"CV");
	}
	else sprintf(tmp,"%u",i);
	NNSet->cParam=i;
	stmp[l]=0;
	str::stradd_(stmp,tmp);
	f=fopen(stmp,"w");	
	for (j=0;j<cf->kcID;j++)
	{
	    for (ii=0;ii<NNSet->NNet->kIn;ii++)
		fprintf(f,"%f ",(float)TestData[j][ii]);
//	    fprintf(f,"- ");
	    NNSet->NNet->NetCalc(TestData[j],NNSet->OutputData);
	    for (ii=0;ii<NNSet->NNet->kOut;ii++)
		fprintf(f,"%f ",(float)NNSet->OutputData[ii]);
	    fprintf(f,"\n");
	}
	fclose(f);
    }
}

/* --------------------------------------------------------------------------*/    

