class Connection
{
 private:
    BaseFloatType InValue;	/* Input Value of Connection */
    BaseFloatType OutValue;	/* Output Value of Connection */
    BaseFloatType (*TFunction)(BaseFloatType,BaseFloatType);	
				/* Transform function */
 public:
    inline void SendToConnection(BaseFloatType Input);
    inline BaseFloatType GetFromConnection();
    void SetTFunction(char *s);

    unsigned char type;		/* 0 - Normal connection between Neurons
				   1 - Input connection
				   2 - Output connection */
    BaseFloatType *Weight;	
    Neuron *from;		/* Null if Input Connection */
    Neuron *to;			/* Null if Output Connection */ 
};

class Neuron
{
 private:
 
    BaseFloatType OutValue;		/* After OutFunction 
					   It will be send to connections
					   *********TO DO*****************
					   Later it was not poor to make
					   own OutFunctions for each
					   connection */
    BaseFloatType (*InFunction)(unsigned int, BaseFloatType*);
    BaseFloatType (*OutFunction)(BaseFloatType, BaseFloatType);

 public:
    BaseFloatType Value;		/* After InFunction */
    BaseFloatType *InValue;	/* Comes from connections */
    BaseFloatType *Weight;	/* May be not used */
    unsigned int InNumber;
    Connection **InConnection;
    unsigned int OutNumber;
    Connection **OutConnection;
    inline void GetFromConnections();
    inline void SendToConnections();
    inline void SetInFunction(char *s);
    inline void SetOutFunction(char *s);
};

class NNetwork
{
 private:
    Connection			**In;
    Connection			**Out;
    ConsoleInit			*cf;
 public:
    Neuron 			*Neu;
    Connection 			*Con;
    unsigned int		kNeu;
    unsigned int 		kCon;
    unsigned int 		kIn;
    unsigned int 		kOut;
    NNetSet			*NNSet;
    NNetwork(ConsoleInit *cf,NNetSet *iNNSet);
    ~NNetwork();
    void NetCalc(BaseFloatType *InputData, BaseFloatType *OutputData);
    unsigned ifConAtachedNeu(unsigned int con, unsigned int neu);
};

class NNetSet
{
 private:
    ConsoleInit			*cf;
    Main			*main;
    void SetQiFunction(char *Qi);
    BaseFloatType (*QualityMinorFunction)(BaseFloatType*,BaseFloatType*);
    void CorelateNeuron(unsigned char Type, unsigned int num, unsigned int Base, unsigned int NumNNet, unsigned char mode);
    void CopyNeuron(unsigned int from, unsigned int to, unsigned int Type, unsigned int num);
    void InitialiseWeight(unsigned char Type, unsigned int Num, unsigned int NumNNet);
    void InitialiseNNet(unsigned int NumNNet);
    void InitialiseData();
    void LoadNNet(unsigned int NumNNet, FILE *f);
    void LoadData(const char *fname);
    void Sort();
    BaseFloatType TestNeurons(unsigned char Type, unsigned int num, unsigned int w1, unsigned int w2);
    unsigned char TestNNets(unsigned int w1, unsigned int w2);
    unsigned char TestEqual(unsigned int w2);
    void DropEquals(unsigned int okNNet);
    void Randomize(unsigned int i, unsigned int BasedOnNNet, unsigned int AdvNum);
    void Corelate(unsigned int i, unsigned int BaseOnNNet, unsigned int AdvNum);
    void Combine(unsigned int i, unsigned int BasedOnNNet, unsigned int AdvNum);


 public:
    unsigned int 		kNNet;		/* Number of NNetworks */
    NNetwork			*NNet;
    unsigned int		cParam;		/* Current weight to use */
    unsigned int 		*rTable;	/* Relacation table */
    BaseFloatType		*Quality;
    BaseFloatType		*OutputData;
    long int			*Old;
    unsigned int DropFlag;
    unsigned char		*pt;		/* Produce in:
						    0 - Randomize
						    1 - Corelate
						    2 - Pic Corelate
						    3 - Corelate with Pics
						    4 - Combine */

    void Drop(unsigned char RequireSorting, unsigned int okNNet);
    void SaveNNSet(const char *path, const char *comment="New");
    void MakeNew();
    NNetSet(ConsoleInit *icf, Main *imain);		/* May be Main may delete */
    ~NNetSet();
    inline BaseFloatType GetQuality(BaseFloatType *TestData);
    void ShowInfo();
};

class Main
{
 private:
    BaseFloatType *Quality;
    BaseFloatType (*QualityMajorFunction)(BaseFloatType*);
    void SetQaFunction(char *Qa);
    void ReadTestData();
    void ReadControlData();
 public:
    ConsoleInit *cf;
    BaseFloatType **TestData;
    BaseFloatType *SaveNeuron;
    BaseFloatType CVQuality;
    unsigned long SaveNeuronProduced;
    NNetSet *NNSet;
    BaseFloatType GetQuality();
    BaseFloatType GetLearnQuality();
    BaseFloatType GetCVQuality();
    void CrossValidate();
    BaseFloatType Main::GetQualites(unsigned int from, unsigned int to);
    void Iterate(unsigned long int);
    void SaveOutput();
    void SaveResults();
    ~Main();
    Main(ConsoleInit *icf);
};

