#! /bin/bash

req_user=$1
run_user=`id -un`

if [ "$req_user" == "" -o "$req_user" == "$run_user" ]; then
    if [ -n "$DBUS_SESSION_BUS_ADDRESS" -a -n "GNOME_KEYRING_CONTROL" ]; then
	ret=`python /etc/scripts/check_keyring.py`
	exit $ret
    else
	req_user="$run_user"
    fi
fi


for name in /tmp/keyring*; do
    if [ ! -d $name ]; then continue; fi

    user=`ls -lad $name | cut -d ' ' -f 3`
    if [ "$req_user" != "$user" ]; then continue; fi

    . /tmp/dbus-$user

    if [ "$req_user" == "$run_user" ]; then
	ret=`DBUS_SESSION_BUS_ADDRESS="$DBUS_SESSION_BUS_ADDRESS" GNOME_KEYRING_CONTROL="$name" python /etc/scripts/check_keyring.py`
    else
	ret=`sudo DBUS_SESSION_BUS_ADDRESS="$DBUS_SESSION_BUS_ADDRESS" GNOME_KEYRING_CONTROL="$name" -u $user python /etc/scripts/check_keyring.py`
    fi
    exit $ret
done
exit 1
